#ifndef __C4DBASETIME_H
#define __C4DBASETIME_H

#include "ge_math.h"

class BaseTime
{
	friend class BaseFile;
	
	private:
		Real nominator;
		Real denominator;
		void Reduce(void);

	public:

		BaseTime(void);
		explicit BaseTime(Real r);		// Aussenwert innen setzen
		BaseTime(Real z, Real n);
		
		Real Get(void) const;
		Real GetNominator(void) const;
		Real GetDenominator(void) const;
		void SetNominator(Real r);
		void SetDenominator(Real r);

		LONG GetFrame(Real fps) const;

		void Quantize(Real fps); 

		friend const BaseTime operator *  (const BaseTime &t1, const BaseTime &t2);
		friend const BaseTime operator /  (const BaseTime &t1, const BaseTime &t2);

		friend const BaseTime operator +  (const BaseTime &t1, const BaseTime &t2);
		friend const BaseTime operator -  (const BaseTime &t1, const BaseTime &t2);

		friend Bool operator == (const BaseTime &t1, const BaseTime &t2);
		friend Bool operator <  (const BaseTime &t1, const BaseTime &t2);
		friend Bool operator != (const BaseTime &t1, const BaseTime &t2);
		friend Bool operator <= (const BaseTime &t1, const BaseTime &t2);
		friend Bool operator >= (const BaseTime &t1, const BaseTime &t2);
		friend Bool operator >  (const BaseTime &t1, const BaseTime &t2);
};
  
#endif